#version 120

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec4 bloommask;


attribute vec4 mc_Entity;

uniform int worldTime;
uniform float frameTimeCounter;
uniform float rainStrength;

varying vec3 globalNormal;
varying vec3 normal;
varying vec3 tangent;
varying vec3 binormal;
varying vec3 viewVector;
varying vec2 waves;

varying float distance;

varying float materialIDs;

//Vanilla Minecraft
#define WAVING_LEAVES
#define WAVING_GRASS
#define WAVING_DEAD_BUSHES
#define WAVING_SAPLINGS
#define WAVING_VINES
#define WAVING_LILY_PADS
#define WAVING_FLOWERS
#define WAVING_WHEAT
#define WAVING_CARROTS
#define WAVING_POTATOES
#define WAVING_MELON_PUMPKIN_STEMS
#define WAVING_COCOA
#define WAVING_SUGAR_CANE
#define WAVING_MUSHROOMS
#define WAVING_NETHER_WART
#define WAVING_WATER
#define WAVING_LAVA

//Biomes O' Plenty
#define WAVING_BIOMES_O_PLENTY

//Pam's Mods
//#define WAVING_TEMPERATE_PLANTS           //Broken for GLSL Shaders Beta 5
//#define WAVING_WEEE_FLOWERS               //Broken for GLSL Shaders Beta 5  

void main() {

	texcoord = gl_MultiTexCoord0;

	lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
	
	vec4 position = gl_Vertex;
	
	//Initialize material masks
	float grass			= 0.0f;
	float leaves		= 0.0f;
	float translucent	= 0.0f;
	float glow			= 0.0f;
	float goldBlock		= 0.0f;
	float ironBlock		= 0.0f;
	float diamondBlock	= 0.0f;
	float emeraldBlock	= 0.0f;
	float sand			= 0.0f;
	float sandstone 	= 0.0f;
	float chiseledSandstone = 0.0f;
	float smoothSandstone = 0.0f;
	float stone 		= 0.0f;
	float cobblestone   = 0.0f;

	float torch 		= 0.0f;
	float lava 			= 0.0f;
	float glowstone		= 0.0f;
	float fire 			= 0.0f;
	
	//Set materials
	//Grass
	if (mc_Entity.x == 31.0) {
		grass = 2.0f;
	}
	
	//Wheat
	if (mc_Entity.x == 59.0) {
		grass = 2.0f;
	}	
	
	//Leaves
	if (mc_Entity.x == 18.0) {
		leaves = 3.0f;
	}	

	
	//Gold block
	if (mc_Entity.x == 41) {
		goldBlock = 20.0f;
	}
	
	//Iron block
	if (mc_Entity.x == 42) {
		ironBlock = 21.0f;
	}
	
	//Diamond Block
	if (mc_Entity.x == 57) {
		diamondBlock = 22.0f;
	}
	
	//Emerald Block
	if (mc_Entity.x == -123) {
		emeraldBlock = 23.0f;
	}
	
	//sand
	if (mc_Entity.x == 12) {
		sand = 24.0f;
	}

	//sandstone
	if (mc_Entity.x == 24 || mc_Entity.x == -128) {
		sandstone = 25.0f;
	}
	
	//stone
	if (mc_Entity.x == 1) {
		stone = 26.0f;
	}
	
	//cobblestone
	if (mc_Entity.x == 4) {
		cobblestone = 27.0f;
	}
	
	float wool = 0.0f;
	if (mc_Entity.x == 35) {
		wool = 28.0f;
	}


	//torch	
	if (mc_Entity.x == 50) {
		torch = 30.0f;
	}

	//lava
	if (mc_Entity.x == 10 || mc_Entity.x == 11) {
		lava = 31.0f;
	}

	//glowstone
	if (mc_Entity.x == 89) {
		glowstone = 32.0f;
	}

	//fire
	if (mc_Entity.x == 51) {
		fire = 33.0f;
	}
	
	
	//Gather materials
	materialIDs = 1.0f;

	//Grass
	if (mc_Entity.x == 31.0) {
		materialIDs = max(materialIDs, 2.0f);
	}
	
	//Wheat
	if (mc_Entity.x == 59.0) {
		materialIDs = max(materialIDs, 2.0f);
	}	
	
	//Leaves
	if (mc_Entity.x == 18.0) {
		materialIDs = max(materialIDs, 3.0f);
	}	

	
	//Gold block
	if (mc_Entity.x == 41) {
		materialIDs = max(materialIDs, 20.0f);
	}
	
	//Iron block
	if (mc_Entity.x == 42) {
		materialIDs = max(materialIDs, 21.0f);
	}
	
	//Diamond Block
	if (mc_Entity.x == 57) {
		materialIDs = max(materialIDs, 22.0f);
	}
	
	//Emerald Block
	if (mc_Entity.x == -123) {
		materialIDs = max(materialIDs, 23.0f);
	}
	
	
	
	//sand
	if (mc_Entity.x == 12) {
		materialIDs = max(materialIDs, 24.0f);
	}

	//sandstone
	if (mc_Entity.x == 24 || mc_Entity.x == -128) {
		materialIDs = max(materialIDs, 25.0f);
	}
	
	//stone
	if (mc_Entity.x == 1) {
		materialIDs = max(materialIDs, 26.0f);
	}
	
	//cobblestone
	if (mc_Entity.x == 4) {
		materialIDs = max(materialIDs, 27.0f);
	}
	
	//wool
	if (mc_Entity.x == 35) {
		materialIDs = max(materialIDs, 28.0f);
	}


	//torch	
	if (mc_Entity.x == 50) {
		materialIDs = max(materialIDs, 30.0f);
	}

	//lava
	if (mc_Entity.x == 10 || mc_Entity.x == 11) {
		materialIDs = max(materialIDs, 31.0f);
	}

	//glowstone and lamp
	if (mc_Entity.x == 89 || mc_Entity.x == 124) {
		materialIDs = max(materialIDs, 32.0f);
	}

	//fire
	if (mc_Entity.x == 51) {
		materialIDs = max(materialIDs, 33.0f);
	}


	float tick = frameTimeCounter;
	
	
float grassWeight = mod(texcoord.t * 16.0f, 1.0f / 16.0f);

float lightWeight = clamp((lmcoord.t * 33.05f / 32.0f) - 1.05f / 32.0f, 0.0f, 1.0f);
	  lightWeight *= 1.1f;
	  lightWeight -= 0.1f;
	  lightWeight = max(0.0f, lightWeight);
	  lightWeight = pow(lightWeight, 5.0f);	  
	  
	  // if (texcoord.t < 0.65f) {
	  // 	grassWeight = 1.0f;
	  // } else {
	  // 	grassWeight = 0.0f;
	  // }	 

	  if (grassWeight < 0.01f) {
	  	grassWeight = 1.0f;
	  } else {
	  	grassWeight = 0.0f;
	  }

const float pi = 3.14159265f;
		
#ifdef WAVING_LEAVES
//Leaves//
    if (mc_Entity.x == 18.0 && texcoord.t < 1.90 && texcoord.t > -1.0) {
		float speed = 0.10;

		float lightWeight = clamp((lmcoord.t * 33.05f / 32.0f) - 1.05f / 32.0f, 0.0f, 1.0f);
			  lightWeight = pow(lightWeight, 6.0f);
		
		float magnitude = (sin((position.y + position.x + tick * pi / ((28.0) * speed))) * 0.15 + 0.15) * 0.30 * lightWeight;
			  magnitude *= grassWeight;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.0f);
		position.z += sin((tick * pi / (17.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.0f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/2.0) * (1.0f + rainStrength * 1.0f);
		
	}
	

	//lower leaf movement
	if (mc_Entity.x == 18.0) {
		float speed = 0.090;
		
		float magnitude = (sin((tick * pi / ((28.0) * speed))) * 0.05 + 0.15) * 0.075;
			  magnitude *= 1.0f - grassWeight;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (162.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (13.0 * speed)) + (position.x + d0)*0.9 + (position.z + d1)*0.9) * magnitude;
		position.z += sin((tick * pi / (16.0 * speed)) + (position.z + d2)*0.9 + (position.x + d3)*0.9) * magnitude;
		position.y += sin((tick * pi / (15.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/1.0);
	}

#endif	
	
#ifdef WAVING_GRASS	
//Grass//
	if (mc_Entity.x == 31.0) {
		float speed = 0.9;
		
		float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.1 + 0.1;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
		float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
		float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
		float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
		position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
	}
	
	
	//small leaf movement
	if (mc_Entity.x == 31.0) {
		float speed = 0.09;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.05 + 0.15) * 0.4;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 1.7f);
	}
	
#endif	



#ifdef WAVING_DEAD_BUSHES
//Dead Bushes//
	if (mc_Entity.x == 32.0) {
		float speed = 1.1;
		
		float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.1 + 0.1;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
		float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
		float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
		float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
		position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
	}
	
	
	//small leaf movement
	if (mc_Entity.x == 32.0) {
		float speed = 0.11;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.05 + 0.15) * 0.4;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 1.7f);
	}
	
#endif	



#ifdef WAVING_SAPLINGS
//Saplings//
	if (mc_Entity.x == 6.0) {
		float speed = 1.0;
		
		float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.1 + 0.1;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
		float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
		float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
		float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
		position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
	}
	
	
	//small leaf movement
	if (mc_Entity.x == 6.0) {
		float speed = 0.10;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.05 + 0.15) * 0.4;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 1.7f);
	}
	
#endif	



#ifdef WAVING_VINES
//Vines//
    if (mc_Entity.x == 106.0 && texcoord.t < 0.60) {//1.20) {
        float speed = 0.3;
        float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((88.0)))) * 0.05 + 0.15) * 0.26;
        float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
        float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5;
        float d2 = sin(tick * pi / (192.0 * speed)) * 3.0 - 1.5;
        float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
        position.x += sin((tick * pi / (16.0 * speed)) + (position.x + d0)*0.5 + (position.z + d1)*0.5 + (position.y)) * magnitude;
        position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*0.5 + (position.x + d3)*0.5 + (position.y)) * magnitude;
    }
   
    //small scale movement
    if (mc_Entity.x == 106.0 && texcoord.t < 0.20) {
        float speed = 0.3;
        float magnitude = (sin(((position.y + position.x)/8.0 + tick * pi / ((88.0)))) * 0.15 + 0.05) * 0.22;
        float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 + 0.5;
        float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 + 0.5;
        float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 + 0.5;
        float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 + 0.5;
        position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude;
        position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude;
        position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/4.0);
    }
	
#endif



#ifdef WAVING_LILY_PADS
    //flowing water
    if (mc_Entity.x == 111.0 && texcoord.t > 0.05) {
        float speed = 0.25;
        float magnitude = (sin((tick * pi / ((28.0) * speed))) * 0.05 + 0.15) * 0.17;
        float d0 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
        float d1 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
        float d2 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
        float d3 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
        position.x += sin((tick * pi / (13.0 * speed)) + (position.x + d0)*0.9 + (position.z + d1)*0.9) * magnitude;
        //position.z += sin((worldTime * 3.14159265358979323846264 / (16.0 * speed)) + (position.z + d2)*0.9 + (position.x + d3)*0.9) * magnitude;
        position.y += sin((tick * pi / (15.0 * speed)) + (position.z + d2) + (position.x + d3)) * magnitude;
        position.y -= 0.04;
    }
    //still water
    if (mc_Entity.x == 111.0 && texcoord.t > 0.05) {
        float speed = 0.4;
        float magnitude = (sin((tick * pi / ((28.0) * speed))) * 0.05 + 0.15) * 0.17;
        float d0 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
        float d1 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
        float d2 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
        float d3 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
        position.x += sin((tick * pi / (13.0 * speed)) + (position.x + d0)*0.9 + (position.z + d1)*0.9) * magnitude;
        position.y += sin((tick * pi / (15.0 * speed)) + (position.z + d2) + (position.x + d3)) * magnitude;
        position.y -= 0.04;
    }
#endif



#ifdef WAVING_FLOWERS	
//Dandelions//
	if (mc_Entity.x == 37.0 || mc_Entity.x == 38.0) {
		float speed = 1.0;
		
		float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.1 + 0.1;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
		float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
		float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
		float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
		position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
	}
	
	
	//small leaf movement
	if (mc_Entity.x == 37.0 || mc_Entity.x == 38.0) {
		float speed = 0.10;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.05 + 0.15) * 0.4;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 1.7f);
	}
	
#endif	



#ifdef WAVING_WHEAT
//Wheat//
	if (mc_Entity.x == 59.0  && gl_MultiTexCoord0.t < gl_MultiTexCoord3.t) {
		float speed = 0.4;
		
		float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.12 + 0.02;
			  magnitude *= grassWeight * 0.2f;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
		float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
		float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
		float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
		position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude;
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude;
	}
	
	//small leaf movement
	if (mc_Entity.x == 59.0 && gl_MultiTexCoord0.t < gl_MultiTexCoord3.t) {
		float speed = 0.08;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.025 + 0.075) * 0.2;
			  magnitude *= grassWeight;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 2.0f);
		position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 2.0f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 2.0f);
	}

#endif
	
	
	
#ifdef WAVING_CARROTS
//Carrots//
	if (mc_Entity.x == 141.0 && texcoord.t < 0.35) {
		float speed = 0.4;
		
		float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.12 + 0.02;
			  magnitude *= grassWeight * 0.2f;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
		float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
		float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
		float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
		position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude;
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude;
	}
	
	//small leaf movement
	if (mc_Entity.x == 141.0 && texcoord.t < 0.35) {
		float speed = 0.08;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.025 + 0.075) * 0.2;
			  magnitude *= grassWeight;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 2.0f);
		position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 2.0f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 2.0f);
	}

#endif	



#ifdef WAVING_POTATOES
//Potatoes//
	if (mc_Entity.x == 142.0) {
		float speed = 0.4;
		
		float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.12 + 0.02;
			  magnitude *= grassWeight * 0.2f;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
		float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
		float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
		float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
		position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude;
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude;
	}
	
	//small leaf movement
	if (mc_Entity.x == 142.0) {
		float speed = 0.08;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.025 + 0.075) * 0.2;
			  magnitude *= grassWeight;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 2.0f);
		position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 2.0f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 2.0f);
	}

#endif	



#ifdef WAVING_LEAVES
//Leaves//
    if (mc_Entity.x == 142.0 && texcoord.t < 1.90 && texcoord.t > -1.0) {
		float speed = 0.10;	
		float magnitude = (sin((position.x + tick * pi / ((28.0) * speed))) * 0.15 + 0.15) * 0.30 * lightWeight;
			  magnitude *= grassWeight;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.0f);
		position.z += sin((tick * pi / (17.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.0f);
		
	}
	

	//lower leaf movement
	if (mc_Entity.x == 142.0) {
		float speed = 0.090;
				float magnitude = (sin((tick * pi / ((28.0) * speed))) * 0.05 + 0.15) * 0.075;
			  magnitude *= 1.0f - grassWeight;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (162.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (13.0 * speed)) + (position.x + d0)*0.9 + (position.z + d1)*0.9) * magnitude;
		position.z += sin((tick * pi / (16.0 * speed)) + (position.z + d2)*0.9 + (position.x + d3)*0.9) * magnitude;

	}

#endif	



#ifdef WAVING_MELON_STEMS
//Melon Stems//
	if (mc_Entity.x == 105.0 || mc_Entity.x == 105.0) {
		float speed = 1.0;
		
		float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.1 + 0.1;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
		float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
		float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
		float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
		position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
	}
	
	
	//small leaf movement
	if (mc_Entity.x == 105.0 || mc_Entity.x == 105.0) {
		float speed = 0.10;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.05 + 0.15) * 0.4;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 1.7f);
	}
	
#endif		
	
	

#ifdef WAVING_COCOA
//Cocoa//	
	if (mc_Entity.x == 127.0 && texcoord.t < 1.90 && texcoord.t > -1.0) {
		float speed = 0.4;
		
		float magnitude = (sin((position.y + position.x + tick * pi / ((28.0) * speed))) * 0.15 + 0.15) * 0.20;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.0f);
		position.z += sin((tick * pi / (17.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.0f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/2.0) * (1.0f + rainStrength * 1.0f);
		
	}
	
/*
	//lower leaf movement
	if (mc_Entity.x == 127.0 && texcoord.t > 0.20) {
		float speed = 0.4;
		
		float magnitude = (sin((tick * pi / ((28.0) * speed))) * 0.05 + 0.15) * 0.1;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (162.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (13.0 * speed)) + (position.x + d0)*0.9 + (position.z + d1)*0.9) * magnitude;
		position.z += sin((tick * pi / (16.0 * speed)) + (position.z + d2)*0.9 + (position.x + d3)*0.9) * magnitude;
		position.y += sin((tick * pi / (15.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/1.0);
	}
*/
#endif



#ifdef WAVING_SUGAR_CANE
//Sugar Cane//	
	if (mc_Entity.x == 83.0 && texcoord.t < 1.90 && texcoord.t > -1.0) {
		float speed = 0.6;
		
		float magnitude = (sin((position.y + position.x + tick * pi / ((28.0) * speed))) * 0.15 + 0.15) * 0.20;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.0f);
		position.z += sin((tick * pi / (17.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.0f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/2.0) * (1.0f + rainStrength * 1.0f);
		
	}
	
/*
	//lower leaf movement
	if (mc_Entity.x == 83.0 && texcoord.t > 0.20) {
		float speed = 0.6;
		
		float magnitude = (sin((tick * pi / ((28.0) * speed))) * 0.05 + 0.15) * 0.1;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (162.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (13.0 * speed)) + (position.x + d0)*0.9 + (position.z + d1)*0.9) * magnitude;
		position.z += sin((tick * pi / (16.0 * speed)) + (position.z + d2)*0.9 + (position.x + d3)*0.9) * magnitude;
		position.y += sin((tick * pi / (15.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/1.0);
	}
*/
#endif	



#ifdef WAVING_MUSHROOMS
//Mushrooms//
	if (mc_Entity.x == 39.0 || mc_Entity.x == 40.0) {
		float speed = 1.1;
		
		float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.1 + 0.1;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
		float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
		float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
		float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
		position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
	}
	
	
	//small leaf movement
	if (mc_Entity.x == 39.0 || mc_Entity.x == 40.0) {
		float speed = 0.11;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.05 + 0.15) * 0.4;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 1.7f);
	}
	
#endif	



#ifdef WAVING_NETHER_WART
//Nether Wart//
	if (mc_Entity.x == 115.0) {
		float speed = 1.2;
		
		float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.1 + 0.1;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
		float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
		float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
		float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
		position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
	}
	
	
	//small leaf movement
	if (mc_Entity.x == 115.0) {
		float speed = 0.12;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.05 + 0.15) * 0.4;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 1.7f);
	}
	
#endif		



#ifdef WAVING_WATER
	if (mc_Entity.x == 8.0 || mc_Entity.x == 9.0) {
		float speed = 0.375;
        float magnitude = (sin((tick * pi / ((28.0) * speed))) * 0.05 + 0.15) * 0.27;
        float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
        float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
        float d2 = sin(tick * pi / (162.0 * speed)) * 3.0 - 1.5;
        float d3 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
        position.y += sin((tick * pi / (15.0 * speed)) +d2 + d3 + (position.z + position.x) * (pi*2/16*3)) * magnitude;
	}
	
#endif



#ifdef WAVING_LAVA
	if (mc_Entity.x == 10.0 || mc_Entity.x == 11.0) {
		float speed = 0.8;
        float magnitude = (sin((tick * pi / ((28.0) * speed))) * 0.05 + 0.15) * 0.27;
        float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
        float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
        float d2 = sin(tick * pi / (162.0 * speed)) * 3.0 - 1.5;
        float d3 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
        position.y += sin((tick * pi / (15.0 * speed)) +d2 + d3 + (position.z + position.x) * (pi*2/16*3)) * magnitude;	/* Thanks Karyonix! :D */
	}
	
#endif



#ifdef WAVING_BIOMES_O_PLENTY
//Leaves//
    if (mc_Entity.x == 1923.0 || mc_Entity.x == 1924.0 || mc_Entity.x == 1926.0 || mc_Entity.x == 1962.0 && texcoord.t < 1.90 && texcoord.t > -1.0) {
		float speed = 0.10;

		float lightWeight = clamp((lmcoord.t * 33.05f / 32.0f) - 1.05f / 32.0f, 0.0f, 1.0f);
			  lightWeight = pow(lightWeight, 6.0f);
			  //lightWeight = max(0.0f, 1.0f - (lightWeight * 5.0f));
		
		float magnitude = (sin((position.y + position.x + tick * pi / ((28.0) * speed))) * 0.15 + 0.15) * 0.30 * lightWeight;
			  magnitude *= grassWeight;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.0f);
		position.z += sin((tick * pi / (17.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.0f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/2.0) * (1.0f + rainStrength * 1.0f);
		
	}
	

	//lower leaf movement
	if (mc_Entity.x == 1923.0 || mc_Entity.x == 1924.0 || mc_Entity.x == 1926.0 || mc_Entity.x == 1962.0) {
		float speed = 0.090;
		
		float magnitude = (sin((tick * pi / ((28.0) * speed))) * 0.05 + 0.15) * 0.075;
			  magnitude *= 1.0f - grassWeight;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (162.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (13.0 * speed)) + (position.x + d0)*0.9 + (position.z + d1)*0.9) * magnitude;
		position.z += sin((tick * pi / (16.0 * speed)) + (position.z + d2)*0.9 + (position.x + d3)*0.9) * magnitude;
		position.y += sin((tick * pi / (15.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/1.0);
	}
	
//Grass//
	if (mc_Entity.x == 1920.0 || mc_Entity.x == 1921.0 || mc_Entity.x == 1925.0) {
		float speed = 0.9;
		
		float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.1 + 0.1;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
		float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
		float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
		float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
		position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
	}
	
	
	//small leaf movement
	if (mc_Entity.x == 1920.0 || mc_Entity.x == 1921.0 || mc_Entity.x == 1925.0) {
		float speed = 0.09;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.05 + 0.15) * 0.4;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 1.7f);
	}
	
//Vines//
    if (mc_Entity.x == 1922.0 || mc_Entity.x == 1932.0 || mc_Entity.x == 1943.0 || mc_Entity.x == 1944.0 && texcoord.t < 0.60) {//1.20) {
        float speed = 0.3;
        float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((88.0)))) * 0.05 + 0.15) * 0.26;
        float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
        float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5;
        float d2 = sin(tick * pi / (192.0 * speed)) * 3.0 - 1.5;
        float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
        position.x += sin((tick * pi / (16.0 * speed)) + (position.x + d0)*0.5 + (position.z + d1)*0.5 + (position.y)) * magnitude;
        position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*0.5 + (position.x + d3)*0.5 + (position.y)) * magnitude;
    }
   
    //small scale movement
    if (mc_Entity.x == 1922.0 || mc_Entity.x == 1932.0 || mc_Entity.x == 1943.0 || mc_Entity.x == 1944.0 && texcoord.t < 0.20) {
        float speed = 0.3;
        float magnitude = (sin(((position.y + position.x)/8.0 + tick * pi / ((88.0)))) * 0.15 + 0.05) * 0.22;
        float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 + 0.5;
        float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 + 0.5;
        float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 + 0.5;
        float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 + 0.5;
        position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude;
        position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude;
        position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/4.0);
    }
	
//Bamboo//
    if (mc_Entity.x == 1927.0 && texcoord.t < 1.90 && texcoord.t > -1.0) {
		float speed = 0.3;

		float lightWeight = clamp((lmcoord.t * 33.05f / 32.0f) - 1.05f / 32.0f, 0.0f, 1.0f);
			  lightWeight = pow(lightWeight, 6.0f);
			  //lightWeight = max(0.0f, 1.0f - (lightWeight * 5.0f));
		
		float magnitude = (sin((position.y + position.x + tick * pi / ((28.0) * speed))) * 0.15 + 0.15) * 0.30 * lightWeight;
			  magnitude *= grassWeight;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (132.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.0f);
		position.z += sin((tick * pi / (17.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.0f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/2.0) * (1.0f + rainStrength * 1.0f);
		
	}
	

	//lower leaf movement
	if (mc_Entity.x == 1927.0) {
		float speed = 0.02;
		
		float magnitude = (sin((tick * pi / ((28.0) * speed))) * 0.05 + 0.15) * 0.075;
			  magnitude *= 1.0f - grassWeight;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (162.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (13.0 * speed)) + (position.x + d0)*0.9 + (position.z + d1)*0.9) * magnitude;
		position.z += sin((tick * pi / (16.0 * speed)) + (position.z + d2)*0.9 + (position.x + d3)*0.9) * magnitude;
		position.y += sin((tick * pi / (15.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/1.0);
	}	
	
//Saplings//
	if (mc_Entity.x == 1937.0 || mc_Entity.x == 1938.0) {
		float speed = 1.0;
		
		float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.1 + 0.1;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
		float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
		float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
		float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
		position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
	}
	
	
	//small leaf movement
	if (mc_Entity.x == 1937.0 || mc_Entity.x == 1938.0) {
		float speed = 0.10;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.05 + 0.15) * 0.4;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 1.7f);
	}	
	
//Mushrooms//
	if (mc_Entity.x == 1967.0) {
		float speed = 1.1;
		
		float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.1 + 0.1;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
		float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
		float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
		float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
		position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
	}
	
	
	//small leaf movement
	if (mc_Entity.x == 1967.0) {
		float speed = 0.11;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.05 + 0.15) * 0.4;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 1.7f);
	}
	
#endif	



#ifdef WAVING_WAVING_TEMPERATE_PLANTS
//Temperate Plants//
	if (mc_Entity.x == 3077.0) {
		float speed = 0.9;
		
		float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.1 + 0.1;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
		float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
		float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
		float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
		position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
	}
	
	
	//small leaf movement
	if (mc_Entity.x == 3077.0) {
		float speed = 0.09;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.05 + 0.15) * 0.4;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 1.7f);
	}
	
#endif	



#ifdef WAVING_WAVING_WEEE_FLOWERS
//Grass//
	if (mc_Entity.x == 4000.0 || mc_Entity.x == 4002.0) {
		float speed = 0.9;
		
		float magnitude = sin((tick * pi / (28.0)) + position.x + position.z) * 0.1 + 0.1;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.z;
		float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.x;
		float d2 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5 + position.x;
		float d3 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5 + position.z;
		position.x += sin((tick * pi / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
		position.z += sin((tick * pi / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude * (1.0f + rainStrength * 1.4f);
	}
	
	
	//small leaf movement
	if (mc_Entity.x == 4000.0 || mc_Entity.x == 4002.0) {
		float speed = 0.09;
		
		float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((28.0)))) * 0.05 + 0.15) * 0.4;
			  magnitude *= grassWeight * 0.5f;
		float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 - 1.5;
		float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
		position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude * (1.0f + rainStrength * 1.7f);
		position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0) * (1.0f + rainStrength * 1.7f);
	}
	
//Vines//
    if (mc_Entity.x == 3100.0 || mc_Entity.x == 3101.0 || mc_Entity.x == 3102.0 || mc_Entity.x == 3103.0 || mc_Entity.x == 3104.0 || mc_Entity.x == 3105.0 || mc_Entity.x == 3106.0 || mc_Entity.x == 3107.0 || mc_Entity.x == 3108.0 || mc_Entity.x == 3109.0 || mc_Entity.x == 3110.0 || mc_Entity.x == 3111.0 || mc_Entity.x == 3112.0 || mc_Entity.x == 3113.0 || mc_Entity.x == 3114.0 || mc_Entity.x == 3115.0 && texcoord.t < 0.60) {//1.20) {
        float speed = 0.3;
        float magnitude = (sin(((position.y + position.x)/2.0 + tick * pi / ((88.0)))) * 0.05 + 0.15) * 0.26;
        float d0 = sin(tick * pi / (122.0 * speed)) * 3.0 - 1.5;
        float d1 = sin(tick * pi / (152.0 * speed)) * 3.0 - 1.5;
        float d2 = sin(tick * pi / (192.0 * speed)) * 3.0 - 1.5;
        float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 - 1.5;
        position.x += sin((tick * pi / (16.0 * speed)) + (position.x + d0)*0.5 + (position.z + d1)*0.5 + (position.y)) * magnitude;
        position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*0.5 + (position.x + d3)*0.5 + (position.y)) * magnitude;
    }
   
    //small scale movement
    if (mc_Entity.x == 3100.0 || mc_Entity.x == 3101.0 || mc_Entity.x == 3102.0 || mc_Entity.x == 3103.0 || mc_Entity.x == 3104.0 || mc_Entity.x == 3105.0 || mc_Entity.x == 3106.0 || mc_Entity.x == 3107.0 || mc_Entity.x == 3108.0 || mc_Entity.x == 3109.0 || mc_Entity.x == 3110.0 || mc_Entity.x == 3111.0 || mc_Entity.x == 3112.0 || mc_Entity.x == 3113.0 || mc_Entity.x == 3114.0 || mc_Entity.x == 3115.0 && texcoord.t < 0.20) {
        float speed = 0.3;
        float magnitude = (sin(((position.y + position.x)/8.0 + tick * pi / ((88.0)))) * 0.15 + 0.05) * 0.22;
        float d0 = sin(tick * pi / (112.0 * speed)) * 3.0 + 0.5;
        float d1 = sin(tick * pi / (142.0 * speed)) * 3.0 + 0.5;
        float d2 = sin(tick * pi / (112.0 * speed)) * 3.0 + 0.5;
        float d3 = sin(tick * pi / (142.0 * speed)) * 3.0 + 0.5;
        position.x += sin((tick * pi / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude;
        position.z += sin((tick * pi / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude;
        position.y += sin((tick * pi / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/4.0);
    }	
	
#endif	



	vec4 locposition = gl_ModelViewMatrix * gl_Vertex;
	
	distance = sqrt(locposition.x * locposition.x + locposition.y * locposition.y + locposition.z * locposition.z);


	gl_Position = gl_ProjectionMatrix * (gl_ModelViewMatrix * position);

	color = gl_Color;
	
	gl_FogFragCoord = gl_Position.z;
	
	
	normal = normalize(gl_NormalMatrix * gl_Normal);
	
	globalNormal = normalize(gl_Normal);

	//if(distance < 80.0f){	
		if (gl_Normal.x > 0.5) {
			//  1.0,  0.0,  0.0
			tangent  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0, -1.0));
			binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
		} else if (gl_Normal.x < -0.5) {
			// -1.0,  0.0,  0.0
			tangent  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
			binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
		} else if (gl_Normal.y > 0.5) {
			//  0.0,  1.0,  0.0
			tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
			binormal = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
		} else if (gl_Normal.y < -0.5) {
			//  0.0, -1.0,  0.0
			tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
			binormal = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
		} else if (gl_Normal.z > 0.5) {
			//  0.0,  0.0,  1.0
			tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
			binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
		} else if (gl_Normal.z < -0.5) {
			//  0.0,  0.0, -1.0
			tangent  = normalize(gl_NormalMatrix * vec3(-1.0,  0.0,  0.0));
			binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
		}
	//}

	
	mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
                          tangent.y, binormal.y, normal.y,
                          tangent.z, binormal.z, normal.z);
	
	viewVector = (gl_ModelViewMatrix * gl_Vertex).xyz;
	viewVector = normalize(tbnMatrix * viewVector);

	
}